$disasterchallengeCount = "14"; //14


// sandbox disaster initialization
function SandboxStart::onExit(%this)
{
   // force all disasters to be turned off
   %scenario = new SLScenario()
   {
      // update disasters only; do not change the map
      stack = true;
      
      // experience marker, time, max disasters
      // (note no experience in sandbox)
      addDisasterNode = "0 180 0";
      disasterStack = $DisasterStack::Push;
   };
   LoadScenario(%scenario);
   
   // all AI behaviors are turned on
   $AI_MONITORJOB     = true;
   $AI_MONITORHOME    = true;
   $AI_MONITORHUNGER  = true;
   
   tsEnableCommand(ProduceSheepCmdData, false);
   BldgCmdButton11.Visible=false;
   
   // initialize the camera fly speed
   GameCamera.FlySpeed = 80;
   tsConvertObjTeam("herocharacter", 0);
   tsSendTaskPopUpDlg("ID_Sandbox", "ID_SandboxIntro", $TaskButton::Okay, "herocharacter", "ID_SandboxIntro");

}

// Walking into platformzone converts mapplatform to team 1
function UnlockPlatformSandbox::onExit(%this)
{
   tsConvertObjTeam("mapPlatform", $OST_PLAYER);
}

function SandboxModetemp::onExit(%this)
{
   tsSendTaskClickDlg("ID_SandboxFreeplay", "ID_SandboxFreeplayText", $TaskButton::Accept, "herocharacter", "ID_SandboxFreeplayText");
   tsSendTaskClickDlg("ID_SandboxChallenge", "ID_SandboxChallengeText", $TaskButton::Accept, "herocharacter", "ID_SandboxChallengeText");
}

/////////////////////////////////////////////
// Start Sandbox Mode Free Play:: Open Range
/////////////////////////////////////////////
function SandboxFreePlay::onExit(%this)
{ 
   tsDestroyTaskDlgIcon("ID_SandboxChallengeText", "herocharacter");
   
   tsConvertObjTeam("herocharacter", 1);

   // increase starting resources
   tsModifyResource($Resource::gold, 500, true);
   tsModifyResource($Resource::wood, 500, true);

   // purchase all experience blocks
   ActivateAllExperience();
   
   // check if the sheep badge is awarded, and if it is, enable sheep
   if (tsIsBadgeAwarded("badge_sheep") == true)
   {
      tsEnableCommand(ProduceSheepCmdData, true);
   }
   // Adds bonus character if Sandbox Disaster Award is awarded
   %pos = herocharacter.getposition();   
   if(tsIsBadgeAwarded("badge_pioneer1"))
   {
      //Spawn MadRussian
      %obj = tsCreateObj("MadRussianData", "", $OST_PLAYER, %pos );
      tsSendTaskPopUpDlg("ID_pioneerAward", "ID_madrussianbadge", $TaskButton::Okay, %obj);
   }
}

/////////////////////////////////////////////
// Start Sandbox Mode Disaster Challenge
/////////////////////////////////////////////
function SandboxDisasterChallenge::onExit(%this)
{
   
   tsDestroyTaskDlgIcon("ID_SandboxFreeplayText", "herocharacter");
   tsConvertObjTeam("herocharacter", 1);
   // increase starting resources
   tsModifyResource($Resource::gold, 500, true);
   tsModifyResource($Resource::wood, 500, true);
   tsModifyResource($Resource::experience, 50, true);
   
   //Unlock all Tutorial Requirements
   //Buildings
   XPBuyChurch.reqCheck0 = true;
   XPBuyWindmill.reqCheck0 = true;
   XPBuyTradingPost.reqCheck0 = true;
   XPBuyWatchTower.reqCheck0 = true;
   XPBuySaloon.reqCheck0 = true;
   XPBuyGeneral.reqCheck0 = true;
   XPBuyGranary.reqCheck0 = true;
   XPBuyBarberShop.reqCheck0 = true;
   XPBuyOuthouse.reqCheck0 = true;
   XPBuyGazebo.reqCheck0 = true;
   XPBuySaloon.reqCheck0 = true;
   XPBuySheriffsOffice.reqCheck0 = true;
   XPBuySheriffsOffice.reqCheck1 = true;
   XPBuyFountain.reqCheck0 = true;
   XPBuyWatertower.reqCheck0 = true;
   XPBuyFlowerpot.reqCheck0 = true;
   XPBuyLumbermill.reqCheck0 = true;
   XPBuyBlacksmith.reqCheck0 = true;
   XPBuyRanch.reqCheck0 = true;
   XPBuyWelcome.reqCheck0 = true;
   XPBuyGoldmine.reqCheck0 = true;
   XPBuyWoodhut.reqCheck0 = true;
   XPBuySheriffsOffice.hideReq1 = false; 
   //Upgrades
   XPBuyCorn.reqCheck0 = true;
   XPBuyPumpkins.reqCheck0 = true;
   
   //Start Disaster Level Award
   TaskModifier.strMarkVertex("SandboxTasks", "SandboxBadgeStart", $TSV_AVAIL);   
   
   //Quest Log
   tsAddQuestToTracker(true, "Disaster Challenge", "", "Environmental Disasters will increase in difficulty the longer you play.", "");
   tsReadyQuest("Disaster Challenge");
   tsAddTaskToTracker("Disaster Challenge", "Disaster Level 0: None", "Disaster Level 0. No Disasters will occur.");
   
   %pos = herocharacter.getposition();   
   if(tsIsBadgeAwarded("badge_pioneer1"))
   {
      //Spawn MadRussian
      tsCreateObj("MadRussianData", "", $OST_PLAYER, %pos );
   }
   
}
// add very weak disasters occasionally
function SandboxDisastersVeryLow::onExit(%this)
{
   
   //Quest Log
   tsReplaceTaskInTracker("Disaster Challenge", "Disaster Level 0: None", "Disaster Level 1: Very Low", "Disaster Level 1. Disasters will occur occasionally.");
   // Reward
   tsModifyResource($Resource::gold, 50, true);
   tsModifyResource($Resource::wood, 50, true);
   tsModifyResource($Resource::experience, 10, true);
   // Bonus
   %resourceCount = rsGetResourceCount($Resource::People);
   tsModifyResource($Resource::experience, %resourceCount, true);
   
   SendProductionToClient(HeroCharacter, "50 gold");
   SendProductionToClient(HeroCharacter, "50 wood");
   SendProductionToClient(HeroCharacter, "10 experience");
   
   tsSendTaskPopUpDlg("ID_SandboxChallenge", "id_DisasterRules", $TaskButton::Okay, "herocharacter");
   
   %scenario = new SLScenario()
   {
      // update disasters only; do not change the map
      stack = true;
      
      // every 3 minutes, a disaster can occur
      addDisasterNode = "0 60 1";
      disasterStack = $DisasterStack::Push;
      
      // frequency pool, respawning time
      disasterBanditRate = "10 120";
      disasterDroughtRate = "10 100";
      disasterEarthquakeRate = "10 120";
      disasterFamineRate = "10 100";
      disasterFireRate = "10 120";
      disasterPlagueRate = "10 100";
      disasterTornadoRate = "10 100";
   };
   
   // update the bandit scenario
   %scenario.disasterBanditScenario = new SLBanditAttackScenario()
   {
      chance = 15;
      duration = 1000;
      
      fadeTime = 1;
      goldMin = 0;
      goldMax = 50;
      goldLow = 1;
      goldHigh = 5;
      lowCount = 1;
      highCount = 1;
      
      happinessCount = -15;
      happinessIncrease = 0;
      happinessPlateau = 10;
      happinessDecrease = 0;
   };
   
   // update the drought scenario
   %scenario.disasterDroughtScenario = new SLDroughtScenario()
   {
      chance = 50;
      addRequirement = well;
      duration = 45;
      
      cost = 0.5;
   };
   
   // update the earthquake scenario
   %scenario.disasterEarthquakeScenario = new SLEarthquakeScenario()
   {
      chance = 15;
      duration = 3;
      
      shakeDistance = 0.3;
      damageLow = 25;
      damageHigh = 30;
   };
   
   // update the famine scenario
   %scenario.disasterFamineScenario = new SLFamineScenario()
   {
      chance = 30;
      //addRequirement = Granary;
      duration = 0;
      
      resource = $Resource::Food;
      cost = 0.5;
   };
   
   // update the fire scenario
   %scenario.disasterFireScenario = new SLFireScenario()
   {
      chance = 15;
      duration = -1;
      
      startStrength = 1;
      
      spreadCount = 2;
      spreadTime = 15;
      spreadChance = 30;
      spreadRadius = 25;
      spreadStrength = 1;
            
      damageTime = 0.5;
      damageStrength = 1;
   };
   
   // update the plague scenario
   %scenario.disasterPlagueScenario = new SLPlagueScenario()
   {
      chance = 40;
      addRequirement = Farm;
      addRequirement = Ranch;
      duration = 45;
      
      produceRate = 0.5;
      addProduce = "wheat";
      addProduce = "corn";
      addProduce = "pumpkin";
      addProduce = "chicken";
      addProduce = "pig";
      addProduce = "cow";
   };
   
   // update the tornado scenario
   %scenario.disasterTornadoScenario = new SLTornadoScenario()
   {
      object = "tornado";

      chance = 15;
      duration = 30;

      travelAngle = 35;
      travelRandom = 25;
      travelTimeLow = 3;
      travelTimeHigh = 6;
      travelSpeedLow = 3;
      travelSpeedHigh = 5;
      radius = 8;
      damage = 20;
   };
   
   LoadScenario(%scenario);
}

// add weak disasters every now and then
function SandboxDisastersLow::onExit(%this)
{
   
   //Quest Log
   tsReplaceTaskInTracker("Disaster Challenge", "Disaster Level 1: Very Low", "Disaster Level 2: Low", "Disaster Level 2. Disasters will occur with some frequency.");
   // Reward
   tsModifyResource($Resource::gold, 75, true);
   tsModifyResource($Resource::wood, 75, true);
   tsModifyResource($Resource::experience, 15, true);
   // Bonus
   %resourceCount = rsGetResourceCount($Resource::People);
   tsModifyResource($Resource::experience, %resourceCount, true);
   
   SendProductionToClient(HeroCharacter, "75 gold");
   SendProductionToClient(HeroCharacter, "75 wood");
   SendProductionToClient(HeroCharacter, "15 experience");
   
   %scenario = new SLScenario()
   {
      // update disasters only; do not change the map
      stack = true;
      
      // every 3 minutes, a disaster can occur
      addDisasterNode = "0 60 1";
      disasterStack = $DisasterStack::Push;
      
      // frequency pool, respawning time
      disasterBanditRate = "10 120";
      disasterDroughtRate = "10 100";
      disasterEarthquakeRate = "10 120";
      disasterFamineRate = "10 100";
      disasterFireRate = "10 120";
      disasterPlagueRate = "10 100";
      disasterTornadoRate = "10 100";
   };
   
   // update the bandit scenario
   %scenario.disasterBanditScenario = new SLBanditAttackScenario()
   {
      chance = 24;
      duration = 1000;

      fadeTime = 1;
      goldMin = 0;
      goldMax = 100;
      goldLow = 5;
      goldHigh = 10;
      lowCount = 1;
      highCount = 2;

      happinessCount = -25;
      happinessIncrease = 0;
      happinessPlateau = 10;
      happinessDecrease = 0;
   };
   
   // update the drought scenario
   %scenario.disasterDroughtScenario = new SLDroughtScenario()
   {
      chance = 50;
      addRequirement = well;
      duration = 40;
      
      cost = 0.5;
   };
   
   // update the earthquake scenario
   %scenario.disasterEarthquakeScenario = new SLEarthquakeScenario()
   {
      chance = 20;
      duration = 5;
      
      shakeDistance = 0.4;
      damageLow = 25;
      damageHigh = 35;
   };
   
   // update the famine scenario
   %scenario.disasterFamineScenario = new SLFamineScenario()
   {
      chance = 55;
      //addRequirement = Granary;
      duration = 0;
      
      resource = $Resource::Food;
      cost = 0.50;
   };
   
   // update the fire scenario
   %scenario.disasterFireScenario = new SLFireScenario()
   {
      chance = 20;
      duration = -1;
      
      startStrength = 2;
      
      spreadCount = 2;
      spreadTime = 15;
      spreadChance = 30;
      spreadRadius = 25;
      spreadStrength = 1;
            
      damageTime = 0.5;
      damageStrength = 1;
   };
   
   // update the plague scenario
   %scenario.disasterPlagueScenario = new SLPlagueScenario()
   {
      chance = 45;
      addRequirement = Farm;
      addRequirement = Ranch;
      duration = 30;
      
      produceRate = 0.5;
      addProduce = "wheat";
      addProduce = "corn";
      addProduce = "pumpkin";
      addProduce = "chicken";
      addProduce = "pig";
      addProduce = "cow";
   };
   
   // update the tornado scenario
   %scenario.disasterTornadoScenario = new SLTornadoScenario()
   {
      object = "tornado";

      chance = 45;
      duration = 60;

      travelAngle = 35;
      travelRandom = 25;
      travelTimeLow = 3;
      travelTimeHigh = 6;
      travelSpeedLow = 3;
      travelSpeedHigh = 5;
      radius = 8;
      damage = 20;
   };
   
   LoadScenario(%scenario);
}

// add average disasters
function SandboxDisastersMedium::onExit(%this)
{
   
   //Quest Log
   tsReplaceTaskInTracker("Disaster Challenge", "Disaster Level 2: Low", "Disaster Level 3: Medium", "Disaster Level 3. Disasters will occur relatively frequently.");
   
   // Reward
   tsModifyResource($Resource::gold, 125, true);
   tsModifyResource($Resource::wood, 125, true);
   tsModifyResource($Resource::experience, 20, true);

   // Bonus
   %resourceCount = rsGetResourceCount($Resource::People);
   tsModifyResource($Resource::experience, %resourceCount, true);
   
   SendProductionToClient(HeroCharacter, "125 gold");
   SendProductionToClient(HeroCharacter, "125 wood");
   SendProductionToClient(HeroCharacter, "20 experience");
   
   // sandbox award population check
   TaskModifier.strMarkVertex("SandboxTasks", "SandboxBadgePopCheck", $TSV_AVAIL);
   
   // enable sheep at medium difficulty
   tsEnableCommand(ProduceSheepCmdData, true);
   
   %scenario = new SLScenario()
   {
      // update disasters only; do not change the map
      stack = true;
      
      // every 2 minutes, a disaster can occur
      addDisasterNode = "0 65 2";
      disasterStack = $DisasterStack::Push;
      
       // frequency pool, respawning time
      disasterBanditRate = "10 120";
      disasterDroughtRate = "10 100";
      disasterEarthquakeRate = "10 120";
      disasterFamineRate = "10 100";
      disasterFireRate = "10 120";
      disasterPlagueRate = "10 100";
      disasterTornadoRate = "10 100";
   };
   
   // update the bandit scenario
   %scenario.disasterBanditScenario = new SLBanditAttackScenario()
   {
      chance = 33;
      duration = 1000;

      fadeTime = 1;
      goldMin = 0;
      goldMax = 100;
      goldLow = 5;
      goldHigh = 10;
      lowCount = 2;
      highCount = 3;

      happinessCount = -25;
      happinessIncrease = 0;
      happinessPlateau = 10;
      happinessDecrease = 0;
   };
   
   // update the drought scenario
   %scenario.disasterDroughtScenario = new SLDroughtScenario()
   {
      chance = 55;
      addRequirement = well;
      duration = 40;
      
      cost = 0.9;
   };
   
   // update the earthquake scenario
   %scenario.disasterEarthquakeScenario = new SLEarthquakeScenario()
   {
      chance = 25;
      duration = 5;
      
      shakeDistance = 0.4;
      damageLow = 25;
      damageHigh = 35;
   };
   
   // update the famine scenario
   %scenario.disasterFamineScenario = new SLFamineScenario()
   {
      chance = 45;
      //addRequirement = Granary;
      duration = 0;
      
      resource = $Resource::Food;
      cost = 0.50;
   };
   
   // update the fire scenario
   %scenario.disasterFireScenario = new SLFireScenario()
   {
      chance = 25;
      duration = -1;
      
      startStrength = 2;
      
      spreadCount = 2;
      spreadTime = 14;
      spreadChance = 30;
      spreadRadius = 25;
      spreadStrength = 1;
            
      damageTime = 0.5;
      damageStrength = 1;
   };
   
   // update the plague scenario
   %scenario.disasterPlagueScenario = new SLPlagueScenario()
   {
      chance = 55;
      addRequirement = Farm;
      addRequirement = Ranch;
      duration = 30;
      
      produceRate = 0.5;
      addProduce = "wheat";
      addProduce = "corn";
      addProduce = "pumpkin";
      addProduce = "chicken";
      addProduce = "pig";
      addProduce = "cow";
   };
   
   // update the tornado scenario
   %scenario.disasterTornadoScenario = new SLTornadoScenario()
   {
      object = "tornado";

      chance = 43;
      duration = 65;

      travelAngle = 35;
      travelRandom = 25;
      travelTimeLow = 3;
      travelTimeHigh = 6;
      travelSpeedLow = 3;
      travelSpeedHigh = 5;
      radius = 8;
      damage = 25;
   };
   
   LoadScenario(%scenario);
}

// add stronger disasters more frequently
function SandboxDisastersHigh::onExit(%this)
{
   
   //Quest Log
   tsReplaceTaskInTracker("Disaster Challenge", "Disaster Level 3: Medium", "Disaster Level 4: High", "Disaster Level 4. Disasters will occur often.");
   // Reward
   tsModifyResource($Resource::gold, 200, true);
   tsModifyResource($Resource::wood, 200, true);
   tsModifyResource($Resource::experience, 35, true);
   // Bonus
   %resourceCount = rsGetResourceCount($Resource::People);
   tsModifyResource($Resource::experience, %resourceCount, true);
   
   SendProductionToClient(HeroCharacter, "200 gold");
   SendProductionToClient(HeroCharacter, "200 wood");
   SendProductionToClient(HeroCharacter, "35 experience");
   
   %scenario = new SLScenario()
   {
      // update disasters only; do not change the map
      stack = true;
      
      // every 3 minutes, a disaster can occur
      addDisasterNode = "0 55 3";
      disasterStack = $DisasterStack::Push;
      
      // frequency pool, respawning time
      disasterBanditRate = "10 100";
      disasterDroughtRate = "10 60";
      disasterEarthquakeRate = "10 100";
      disasterFamineRate = "10 60";
      disasterFireRate = "10 100";
      disasterPlagueRate = "10 60";
      disasterTornadoRate = "10 60";
   };
   
   // update the bandit scenario
   %scenario.disasterBanditScenario = new SLBanditAttackScenario()
   {
      chance = 35;
      duration = 1000;

      fadeTime = 1;
      goldMin = 0;
      goldMax = 100;
      goldLow = 5;
      goldHigh = 10;
      lowCount = 2;
      highCount = 3;

      happinessCount = -25;
      happinessIncrease = 0;
      happinessPlateau = 10;
      happinessDecrease = 0;
   };
   
   // update the drought scenario
   %scenario.disasterDroughtScenario = new SLDroughtScenario()
   {
      chance = 35;
      addRequirement = well;
      duration = 40;
      
      cost = 0.5;
   };
   
   // update the earthquake scenario
   %scenario.disasterEarthquakeScenario = new SLEarthquakeScenario()
   {
      chance = 28;
      duration = 5;
      
      shakeDistance = 0.4;
      damageLow = 25;
      damageHigh = 35;
   };
   
   // update the famine scenario
   %scenario.disasterFamineScenario = new SLFamineScenario()
   {
      chance = 55;
      //addRequirement = Granary;
      duration = 0;
      
      resource = $Resource::Food;
      cost = 0.50;
   };
   
   // update the fire scenario
   %scenario.disasterFireScenario = new SLFireScenario()
   {
      chance = 25;
      duration = -1;
      
      startStrength = 2;
      
      spreadCount = 2;
      spreadTime = 15;
      spreadChance = 30;
      spreadRadius = 25;
      spreadStrength = 1;
            
      damageTime = 0.5;
      damageStrength = 1;
   };
   
   // update the plague scenario
   %scenario.disasterPlagueScenario = new SLPlagueScenario()
   {
      chance = 65;
      addRequirement = Farm;
      addRequirement = Ranch;
      duration = 30;
      
      produceRate = 0.5;
      addProduce = "wheat";
      addProduce = "corn";
      addProduce = "pumpkin";
      addProduce = "chicken";
      addProduce = "pig";
      addProduce = "cow";
   };
   
   // update the tornado scenario
   %scenario.disasterTornadoScenario = new SLTornadoScenario()
   {
      object = "tornado";

      chance = 70;
      duration = 60;

      travelAngle = 35;
      travelRandom = 25;
      travelTimeLow = 3;
      travelTimeHigh = 6;
      travelSpeedLow = 3;
      travelSpeedHigh = 5;
      radius = 8;
      damage = 25;
   };
   
   LoadScenario(%scenario);
}

// add strong disasters frequently
function SandboxDisastersVeryHigh::onExit(%this)
{
   //Quest Log
   tsReplaceTaskInTracker("Disaster Challenge", "Disaster Level 4: High", "Disaster Level 5: Very High", "Disaster Level 5. Disasters will occur very often.");
   // Reward
   tsModifyResource($Resource::gold, 250, true);
   tsModifyResource($Resource::wood, 250, true);
   tsModifyResource($Resource::experience, 45, true);
   // Bonus
   %resourceCount = rsGetResourceCount($Resource::People);
   tsModifyResource($Resource::experience, %resourceCount, true);
   
   SendProductionToClient(HeroCharacter, "250 gold");
   SendProductionToClient(HeroCharacter, "250 wood");
   SendProductionToClient(HeroCharacter, "45 experience");
   
   %scenario = new SLScenario()
   {
      // update disasters only; do not change the map
      stack = true;
      
      // every 3 minutes, a disaster can occur
      addDisasterNode = "0 40 4";
      disasterStack = $DisasterStack::Push;
      
      // frequency pool, respawning time
      disasterBanditRate = "15 100";
      disasterDroughtRate = "10 60";
      disasterEarthquakeRate = "10 100";
      disasterFamineRate = "15 60";
      disasterFireRate = "12 100";
      disasterPlagueRate = "10 60";
      disasterTornadoRate = "10 60";
   };
   
   // update the bandit scenario
   %scenario.disasterBanditScenario = new SLBanditAttackScenario()
   {
      chance = 45;
      duration = 1000;

      fadeTime = 1;
      goldMin = 0;
      goldMax = 100;
      goldLow = 5;
      goldHigh = 10;
      lowCount = 2;
      highCount = 4;

      happinessCount = -25;
      happinessIncrease = 0;
      happinessPlateau = 10;
      happinessDecrease = 0;
   };
   
   // update the drought scenario
   %scenario.disasterDroughtScenario = new SLDroughtScenario()
   {
      chance = 55;
      addRequirement = well;
      duration = 40;
      
      cost = 0.8;
   };
   
   // update the earthquake scenario
   %scenario.disasterEarthquakeScenario = new SLEarthquakeScenario()
   {
      chance = 35;
      duration = 5;
      
      shakeDistance = 0.4;
      damageLow = 35;
      damageHigh = 45;
   };
   
   // update the famine scenario
   %scenario.disasterFamineScenario = new SLFamineScenario()
   {
      chance = 45;
      //addRequirement = Granary;
      duration = 0;
      
      resource = $Resource::Food;
      cost = 0.50;
   };
   
   // update the fire scenario
   %scenario.disasterFireScenario = new SLFireScenario()
   {
      chance = 35;
      duration = -1;
      
      startStrength = 2;
      
      spreadCount = 2;
      spreadTime = 15;
      spreadChance = 30;
      spreadRadius = 25;
      spreadStrength = 1;
            
      damageTime = 0.5;
      damageStrength = 1;
   };
   
   // update the plague scenario
   %scenario.disasterPlagueScenario = new SLPlagueScenario()
   {
      chance = 65;
      addRequirement = Farm;
      addRequirement = Ranch;
      duration = 35;
      
      produceRate = 0.5;
      addProduce = "wheat";
      addProduce = "corn";
      addProduce = "pumpkin";
      addProduce = "chicken";
      addProduce = "pig";
      addProduce = "cow";
   };
   
   // update the tornado scenario
   %scenario.disasterTornadoScenario = new SLTornadoScenario()
   {
      object = "tornado";

      chance = 70;
      duration = 60;

      travelAngle = 35;
      travelRandom = 25;
      travelTimeLow = 3;
      travelTimeHigh = 6;
      travelSpeedLow = 3;
      travelSpeedHigh = 5;
      radius = 8;
      damage = 30;
   };
   
   LoadScenario(%scenario);
}

// add very strong disasters very frequently
function SandboxDisastersExtremelyHigh::onExit(%this)
{
   
   //Quest Log
   tsReplaceTaskInTracker("Disaster Challenge", "Disaster Level 5: Very High", "Disaster Level 6: Extreme", "Disaster Level 6. Disasters will occur extremely often. Hold on to your hat.");
   
   // Reward
   tsModifyResource($Resource::gold, 350, true);
   tsModifyResource($Resource::wood, 350, true);
   tsModifyResource($Resource::experience, 50, true);
   // Bonus
   %resourceCount = rsGetResourceCount($Resource::People);
   tsModifyResource($Resource::experience, %resourceCount, true);
   
   SendProductionToClient(HeroCharacter, "350 gold");
   SendProductionToClient(HeroCharacter, "350 wood");
   SendProductionToClient(HeroCharacter, "50 experience");
   
   %scenario = new SLScenario()
   {
      // update disasters only; do not change the map
      stack = true;
      
      // every 1 minutes, a disaster can occur
      addDisasterNode = "0 40 4";
      disasterStack = $DisasterStack::Push;
      
      // frequency pool, respawning time
      disasterBanditRate = "14 60";
      disasterDroughtRate = "10 60";
      disasterEarthquakeRate = "10 60";
      disasterFamineRate = "10 60";
      disasterFireRate = "14 60";
      disasterPlagueRate = "10 60";
      disasterTornadoRate = "14 50";
   };
   
   // update the bandit scenario
   %scenario.disasterBanditScenario = new SLBanditAttackScenario()
   {
      chance = 60;
      duration = 1000;

      fadeTime = 1;
      goldMin = 0;
      goldMax = 100;
      goldLow = 5;
      goldHigh = 10;
      lowCount = 2;
      highCount = 4;

      happinessCount = -25;
      happinessIncrease = 0;
      happinessPlateau = 10;
      happinessDecrease = 0;
   };
   
   // update the drought scenario
   %scenario.disasterDroughtScenario = new SLDroughtScenario()
   {
      chance = 45;
      addRequirement = well;
      duration = 30;
      
      cost = 0.5;
   };
   
   // update the earthquake scenario
   %scenario.disasterEarthquakeScenario = new SLEarthquakeScenario()
   {
      chance = 35;
      duration = 5;
      
      shakeDistance = 0.4;
      damageLow = 30;
      damageHigh = 40;
   };
   
   // update the famine scenario
   %scenario.disasterFamineScenario = new SLFamineScenario()
   {
      chance = 55;
      //addRequirement = Granary;
      duration = 0;
      
      resource = $Resource::Food;
      cost = 0.60;
   };
   
   // update the fire scenario
   %scenario.disasterFireScenario = new SLFireScenario()
   {
      chance = 38;
      duration = -1;
      
      startStrength = 2;
      
      spreadCount = 2;
      spreadTime = 15;
      spreadChance = 30;
      spreadRadius = 25;
      spreadStrength = 1;
            
      damageTime = 0.5;
      damageStrength = 1;
   };
   
   // update the plague scenario
   %scenario.disasterPlagueScenario = new SLPlagueScenario()
   {
      chance = 65;
      addRequirement = Farm;
      addRequirement = Ranch;
      duration = 35;
      
      produceRate = 0.5;
      addProduce = "wheat";
      addProduce = "corn";
      addProduce = "pumpkin";
      addProduce = "chicken";
      addProduce = "pig";
      addProduce = "cow";
   };
   
   // update the tornado scenario
   %scenario.disasterTornadoScenario = new SLTornadoScenario()
   {
      object = "tornado";

      chance = 75;
      duration = 60;

      travelAngle = 35;
      travelRandom = 25;
      travelTimeLow = 3;
      travelTimeHigh = 6;
      travelSpeedLow = 3;
      travelSpeedHigh = 5;
      radius = 8;
      damage = 35;
   };
   
   LoadScenario(%scenario);
}
// Completed Sandbox Disaster Mode
function SandboxComplete::onExit()
{
   //Quest log   
   tsCompleteTaskInTracker("Disaster Challenge", "Disaster Level 6: Extreme");
   if(!(SandboxBadgePopUpkeep.isComplete()))
   {
      tsAwardBadge("badge_sandboxchallenge", true);
      tsCompleteTaskInTracker("Disaster Challenge Award", "Maintain a population of "@ $disasterchallengeCount @" citizens");
   }
   TaskModifier.strMarkVertex("SandboxTasks", "SandboxBadgePopUpkeep", $TSV_CMPLETE);
}     

//******************************************************
//* Sandbox Disaster Badge Award
//******************************************************

function SandboxBadgeStart::onEnter()
{
   //Quest log
   tsAddQuestToTracker(false, "Disaster Challenge Award", "Reach a population of "@ $disasterchallengeCount @" citizens by Disaster Level 3 and maintain that population of at least "@ $disasterchallengeCount @" until the end of Disaster Level 6.", "Reach a population of "@ $disasterchallengeCount @" citizens by Disaster Level 3 and maintain that population of at least "@ $disasterchallengeCount @" until the end of Disaster Level 6.", "Reward: Disaster Challenge Award");
   tsReadyQuest("Disaster Challenge Award");
   
   TaskModifier.strMarkVertex("SandboxTasks", "SandboxBadgeStart", $TSV_CMPLETE); 
}
function SandboxBadgePopCheck::onEnter()
{
   
   if (rsGetResourceCount($Resource::People) >= $disasterchallengeCount) 
	{
	   //Start Disaster Award population upkeep
	   TaskModifier.strMarkVertex("SandboxTasks", "SandboxBadgePopUpkeep", $TSV_AVAIL);
	   tsAddTaskToTracker("Disaster Challenge Award", "Maintain a population of "@ $disasterchallengeCount @" citizens", "Maintain a population of "@ $disasterchallengeCount @" citizens until the end of Disaster Level 6."); 
	}
	else if(rsGetResourceCount($Resource::People) < $disasterchallengeCount)
	{ 
      //Quest log
      tsDisableQuest("Disaster Challenge Award");
	}
   TaskModifier.strMarkVertex("SandboxTasks", "SandboxBadgePopCheck", $TSV_CMPLETE); 
}
function SandboxBadgePopUpkeep::onUpdate()
{
   if (rsGetResourceCount($Resource::People) < $disasterchallengeCount) 
	{
	   //Quest log
      tsDisableQuest("Disaster Challenge Award");
      TaskModifier.strMarkVertex("SandboxTasks", "SandboxBadgePopUpkeep", $TSV_CMPLETE); 
	}
}
